package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VdocOs6Dao;
import com.ejie.ab04b.model.VdocOs6;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdocOs6ServiceImpl generated by UDA, 30-jun-2017 14:27:59.
 * 
 * @author UDA
 */

@Service(value = "vdocOs6Service")
public class VdocOs6ServiceImpl implements VdocOs6Service {

	@Autowired
	private VdocOs6Dao vdocOs6Dao;

	/**
	 * Inserts a single row in the VdocOs6 table.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the vdoc os 6
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdocOs6 add(VdocOs6 vdocOs6) {
		return this.vdocOs6Dao.add(vdocOs6);
	}

	/**
	 * Updates a single row in the VdocOs6 table.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the vdoc os 6
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdocOs6 update(VdocOs6 vdocOs6) {
		return this.vdocOs6Dao.update(vdocOs6);
	}

	/**
	 * Finds a single row in the VdocOs6 table.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the vdoc os 6
	 */
	public VdocOs6 find(VdocOs6 vdocOs6) {
		return (VdocOs6) this.vdocOs6Dao.find(vdocOs6);
	}

	/**
	 * Deletes a single row in the VdocOs6 table.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *
	 * @param vdocOs6 the vdoc os 6
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VdocOs6 vdocOs6) {
		this.vdocOs6Dao.remove(vdocOs6);
	}

	/**
	 * Finds a list of rows in the VdocOs6 table.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdocOs6>
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VdocOs6> findAll(VdocOs6 vdocOs6,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VdocOs6>) this.vdocOs6Dao.findAll(vdocOs6,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VdocOs6 table using like.
	 * 
	 *  vdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdocOs6>
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VdocOs6> findAllLike(VdocOs6 vdocOs6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VdocOs6>) this.vdocOs6Dao.findAllLike(vdocOs6,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VdocOs6 table.
	 * 
	 *  filterVdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVdocOs6 the filter vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VdocOs6 filterVdocOs6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vdocOs6Dao.removeMultiple(filterVdocOs6, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VdocOs6 table.
	 * 
	 *  filterVdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VdocOs6>
	 *
	 * @param filterVdocOs6 the filter vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VdocOs6> filter(VdocOs6 filterVdocOs6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VdocOs6> listaVdocOs6 = this.vdocOs6Dao.findAllLike(filterVdocOs6,
				jqGridRequestDto, false);
		Long recordNum = this.vdocOs6Dao.findAllLikeCount(
				filterVdocOs6 != null ? filterVdocOs6 : new VdocOs6(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VdocOs6>> reorderSelection = this.vdocOs6Dao
					.reorderSelection(filterVdocOs6, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VdocOs6>(jqGridRequestDto, recordNum,
					listaVdocOs6, reorderSelection);
		}
		return new JQGridResponseDto<VdocOs6>(jqGridRequestDto, recordNum,
				listaVdocOs6);
	}

	/**
	 * Searches rows in the VdocOs6 table.
	 * 
	 *  filterVdocOs6
	 *            VdocOs6
	 *  searchVdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VdocOs6>>
	 *
	 * @param filterVdocOs6 the filter vdoc os 6
	 * @param searchVdocOs6 the search vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VdocOs6>> search(VdocOs6 filterVdocOs6,
			VdocOs6 searchVdocOs6, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.vdocOs6Dao.search(filterVdocOs6, searchVdocOs6,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VdocOs6 table.
	 * 
	 *  filterVdocOs6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVdocOs6 the filter vdoc os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VdocOs6 filterVdocOs6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vdocOs6Dao.reorderSelection(filterVdocOs6,
				jqGridRequestDto, startsWith);
	}

}
